/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2014 Ted Williams WA0EIR
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 4.1 - Feb 2014
 */

const char *helpTopics[NUM_TOPICS] =
{
"About",
"Introduction",
"Menu Bar",
"Help Windows",
"Main Window",
"Tuning",
"Secondary Windows",
"Sending Files",
"Macros",
"Resources",
"Accelerator Keys"
};

const char *helpText[NUM_TOPICS] = {

/***** INTRODUCTION NON-SECTION *****/

"About - not used in helpText",

/***** INTRODUCTION SECTION *****/

"\n\
Twpsk is a sound card program that allows you to transmit and receive \
PSK31, the digital mode developed by Peter, G3PLX. It has a \
Graphical User Interface (GUI) which uses the Motif or lessTiff libraries. \n\
\n\
The GUI consists of the main window and several other windows that you \
pop up as needed. The main window has five sections: a Menu Bar, \
text windows, tuning indicators and their controls, T/R controls, and \
Mode buttons. \n\
\n\
The Menu Bar runs across the top of the main window and has File, Controls, \
Seek, and Help buttons. Clicking on these buttons will display their drop down \
menus with additional buttons. See the the Menu Bar section for more \
information. \n\
\n\
Below the Menu Bar are two text windows with scroll bars. The top one \
displays received text. It also displays your transmit text as it is being \
sent. The bottom text window is where you enter transmit text.  See the \
Main Window section for more information. \n\
\n\
Under the text windows is the Spectrum display. It shows the signals on and \
around the receive frequency. It displays signals in two forms, Spectrum \
Analyzer or Waterfall. \n\
\n\
Just below the left end of the Spectrum display are two rows of buttons \
labeled Display Controls. With the first row, you select the display type \
for the Spectrum display, either a Spectrum Analyzer or a Waterfall, as \
indicated by the pictures on the buttons. The second row has three buttons \
that let you change the bandwidth displayed in the Spectrum Display. \n\
\n\
In the lower left corner of the main window is a Phase Scope. It shows the \
phase shift of a PSK signal. Both the Spectrum display and the Phase Scope \
are used for tuning. See the Main Window and Tuning sections for more \
information. \n\
\n\
The T/R Controls are grouped in the bottom center of the interface. These \
control the receive and transmit frequency, AFC, NET, and transmit, receive, \
and tune controls. See the Main Window section for more information. \n\
\n\
The Modes buttons are the group of five buttons and indicators along the \
right hand side. These select different modes and show status information. \
See the Main Window section for more information. \n\
\n",

/* MENU BAR SECTION */

"\n\
The Menu Bar has four buttons - File, Controls, Seek and Help. Clicking \
on these buttons causes a drop down menu to be displayed. The buttons on \
the drop down menus can be used to control most of the program's operations. \n\
\n\
These buttons (and most other buttons on the GUI) can also be \"pressed\" \
from the keyboard too. This is a great way to speed up operation, since \
you don't have to move your hand back and forth between the keyboard and \
the mouse. See the Accelerator Keys section for more information. \n\
\n\
All of the drop down menus have a dashed line on top. This is \
the \"tear off\" button. Selecting the \"tear off\" will create a new \
window that contains all the buttons in the drop down menu. This can be \
handy when you need to frequently use the buttons in a drop down menu. \n\
\n\
The Menu Bar buttons, and their drop down menus are described below.  See \
the Main Window section for additional information on all of these buttons. \n\
\n\
\n\
File Menu Button \n\
\n\
The File button is used to send text files and to exit twpsk. You can \
have up to 9 files defined in this drop down menu. See the Sending Files \
section for more information.\n\
\n\
The last button in the file menu is labeled QRT. Use this button to exit \
the program. \n\
\n\
\n\
Controls Menu Button \n\
The Controls button displays a drop down menu with several buttons. There \
functions are described below. \n\
\n\
Most of the buttons on this drop down menu have a corresponding button on \
the main window, which you can select with a mouse click. All of these \
buttons can also be \"pressed\" from the keyboard too, which is even faster \
and easier. See the Accelerator Keys section for more information. \n\
\n\
Video \n\
The Video button pops up a dialog box to control the speed and brightness \
of the Spectrum display. This button does not have a corresponding button \
on the main window. See the Secondary Windows section for more information. \n\
\n\
Recv \n\
This button will switch the program to receive mode. It does exactly \
the same as the Recv button in the T/R controls group on the main window. \n\
\n\
Xmit \n\
This button will switch the program to transmit mode. It operates \
exactly the same as the Xmit button in the T/R controls group on the \
main window. \n\
\n\
Tune \n\
This button will switch the program to Tune mode. It causes the sound card \
to produce a 1000 cycle tone that you can use to tune your rig. It operates \
exactly the same as the Tune button in the T/R group on the main window. \n\
\n\
Broad \n\
This button switches the Spectrum Display to the broad range. The \
Spectrum Display will display +/- 1500 Hz. from the Rx Freq. This button \
performs the same operation as the B button the Display Control group. \n\
\n\
Medium \n\
This button switches the Spectrum Display to the medium range. The \
Spectrum Display will display +/- 750 Hz. from the Rx Freq. This button \
performs the same operation as the M button in the Display Control group. \n\
\n\
Narrow \n\
This button switches the Spectrum Display to the narrow range. The \
Spectrum display will display +/- 375 Hz. from the Rx Freq. This button \
performs the same operation as the N button in the Display Control group. \n\
\n\
Spectrum \n\
The Spectrum button makes the display produce a classic spectrum \
analyzer output. The horizontal scale is frequency, centered on the \
Rx Freq, and the vertical scale is signal strength. \n\
\n\
Waterfall \n\
The Waterfall button makes the display produce a waterfall output. The \
horizontal scale is frequency, centered on the Rx Freq. The signal strength \
is based on a gray scale.  A strong signal is white. As a signal gets weaker, \
it will be a darker shade of gray. New data is displayed at the bottom, and \
older data runs off the top of the display. Since this is Linux, the \
waterfall flows up hill. \n\
\n\
Flow Up \n\
Since the day twpsk was written, the waterfall always flowed up.  And why \
not?  After all, this is linux.  If you prefer to have the waterfall flow \
down, deselect this toggle button. \n\
\n\
Local Caps \n\
With PSK's variable length Unicode, it is best to send lower case characters \
because lower case codes are shorter than their upper case equivalent.  \
However, some people find it easier to read text printed in upper case. \
When this button is sellected, all received and transmitted text will be \
displayed in upper case.  However, the transmitted characters will be sent in \
the case they were typed - upper or lower. \n\
\n\
Open Decoder \n\
This button opens a secondary receiver window at the current receive \
frequency. This is an easy way to put the current signal into a \
secondary decoder window, so you can tune in another station. See the \
Secondary Windows section for more information. \n\
\n\
\n\
Seek Menu Button \n\
\n\
These buttons control the starting and stopping of scan operations. Since \
these buttons do not have a corresponding button on the main window, it is \
easier to \"press\" them from the keyboard. See the Accelerator Keys section \
for more information. \n\
\n\
The scan will stop when a PSK signal is detected. A scan will also stop when \
it reaches 0.0 Hz. or the maximum frequency, 4000 Hz. The display is gray for \
frequencies less than 0.0 Hz, and above the maximum frequency. \n\
\n\
NOTE: Once you start a scan, pressing any of these buttons, \
(Up, Down or Halt) will stop the scan. \n\
\n\
Up \n\
The Up button starts a scan up the band for the next PSK signal. \n\
\n\
Down \n\
The Down button starts a scan down the band for the next PSK \
signal. \n\
\n\
Halt \n\
This button will stop a scan. \n\
\n\
\n\
Help Menu Button \n\
\n\
The Menu Bar's Help button displays the About button and a button for \
each of the Help sections. \n\
\n\
About Button \n\
This button pops up the About Dialog that tells you a little bit about \
who wrote this thing. \n\
\n\
Help Topic Buttons \n\
The remaining buttons in the Help pull down are: \n\
\n\
See the Help Windows section for more information.",

/***** HELP SECTION *****/

"The Help window is opened by selecting one of the buttons, other than the \
About button, under the Menu Bar's Help button. The label on the \
top of the Help window shows which section is being displayed. The Help \
window has three buttons - Find, Find Again, and Clear.\n\
\n\
Find Button\n\
This button pops up a window where you type the text string that \
you want to find. Buttons on this window allow you to search the current \
section or all of the Help sections. After pushing one of these buttons, \
the Help will be searched, and if it is found, the window will scroll to \
the matching text and highlight it. \n\
\n\
NOTE: This search is not case sensitive. \n\
\n\
Now you can use the Find Again button to find the next match, or \
you can press the Find button to start a new search with a new string. \n\
\n\
Find Again Button\n\
Once your string has been found, the Find Again button becomes active. You \
use this to find the next match. If the search reaches the end of the \
section, or if all section have been searched when searching all section, \
a \"String Not Found\" message will be displayed. \n\
",

/***** MAIN WINDOW SECTION *****/

"\n\
This section describes all of the objects in the main window, except for \
the Menu Bar, which has its own section. \n\
\n\
\n\
Receive Text \n\
This window is located directly below the Menu Bar. Received text \
is always placed at the end of the window's text. You can use the \
scroll bar on the right to scroll back and see text that has ran off the \
top of the window. This does not affect receiving new text, which will \
still be added to the end. The background color of the window is darker \
when you scroll back. This is just an indication to you that you must \
scroll back to the bottom to see any newly received characters. Once you \
scroll back to the bottom, the background color will return to normal. \n\
\n\
The Receive and the Transmit Text windows have pop up menus that allow \
you to clear the text. To activate the menu, point the mouse in one of these \
text windows, and press the right mouse button. The pop up menu has a Clear \
button. \n\
\n\
Resize Text Window Panes \n\
Between the Receive and Transmit Text scroll bars is a small square \
button. When you point at the square, the pointer changes to a + sign. If \
you then hold down the left mouse button and drag, you can change the sizes \
of these windows. \n\
\n\
Transmit Text \n\
The Transmit Text window is located below the Receive Text window. To \
enter text in this window, it must have the focus, as indicated by a black \
border around it. Click on the Receive Text window and then click on the \
Transmit Text window to see the border. \n\
\n\
To make the interface easier to use, the program is written so that pushing \
the Xmit or Recv buttons will forces the focus to the Transmit Text \
window. This tends to keep the focus where you need it. \n\
\n\
The scroll bar allows you to scroll back to see previously transmitted text. \
The window will automatically scroll back to the bottom when you enter text \
in it. \n\
\n\
This window also has a pop up menu that allows you to clear the text. To \
activate the menu, point the mouse in the window, and press the right mouse \
button. The pop up menu has the Clear button. \n\
\n\
Tuning Indicators \n\
The Scope and Spectrum Displays are used to help tune PSK signals. The \
Display Controls are used to change the type and bandwidth of the Spectrum \
Display. See the Tuning section for more details. \n\
\n\
Scope \n\
The Scope is a PSK31 tuning aid. It shows the phase shifts of a PSK31 \
signal. A properly tuned signal will be a vertical line. The line will be \
one of three colors. \n\
\n\
Red indicates no signal or an improperly tuned one. \n\
\n\
Yellow lines indicated a signal has been detected. A properly tuned \
signal will draw a vertical yellow line. The length of the line indicates \
relative signal strength. \n\
\n\
See the Tuning section for more information.\n\
\n\
While transmitting, the scoped will show a green line. \n\
\n\
Spectrum Display \n\
The Spectrum Display, located below the Text windows, is also used for tuning \
PSK31 signals and can be used in conjunction with the Scope Display. You \
can think of it as a graph that displays the signals on and around the \
receive frequency. The horizontal axis represents frequency. The red \
line is the current receive frequency, which is the value displayed in the \
Rx Freq box. \n\
\n\
The frequency range displayed around the center frequency can be set to \
one of three ranges by clicking the B (Broad), M (Medium), or N (Narrow) \
buttons. \n\
\n\
The Spectrum Display is used mostly to tune in signals. Simply point at a \
signal, and click the mouse.  See the Tuning section for more information.\n\
\n\
Signals are shown in one of two forms that you select with the Spectrum \
Analyzer or Waterfall buttons below. \n\
\n\
Spectrum Analyzer Mode \n\
Under the Display Controls label are two rows of buttons.  This button is the \
left hand button in the first row. It produces a classic spectrum analyzer \
display. The height of the signal is the relative signal strength. The \
position of the signal with respect to the red line indicates if it is above \
or below the current receive frequency. \n\
\n\
Waterfall Mode \n\
The right hand button in the first row selects the Waterfall Mode. It \
displays a few seconds history of the signals. A gray scale is used to \
show relative signal strength. A strong signal is white and weaker \
signals are progressively darker shades of gray. \n\
\n\
B   (Broad) \n\
With the B button selects the broad range. The Spectrum Display will show \
a frequency range of +/- 1500 Hz. from the center frequency. \n\
\n\
M   (Medium) \n\
With the M (Medium) button selected, the Spectrum Display will display a \
range of +/- 750 Hz. from the center frequency. \n\
\n\
N   (Narrow) \n\
With the N (Narrow) button selected, the Spectrum Display will show a \
frequency range of +/- 375 Hz. from the center frequency. \n\
\n\
Frequency and T/R Controls \n\
The T/R Controls are located at the bottom center of the main window. There \
are controls to adjust the Rx Freq, Tx Freq, and two other buttons control \
AFC and NET. The bottom group of three buttons key your transceiver. \n\
\n\
Rx Freq \n\
This text field shows the center receive frequency. If you click in this \
window, you can edit the number to select a desired frequency. \n\
\n\
NOTE: While the window is selected, the AFC is disabled. To indicate \
that the AFC is disabled, the background changes to a darker color. \
Clicking outside the Rx Freq will enable the AFC again. \n\
\n\
NOTE: The text is also white during a scan. It returns to black when a \
PSK31 signal is found. \n\
\n\
Rx Freq Arrows \n\
Another way to change the frequency is with the up and down arrow buttons \
to the right of the Rx Freq window. Clicking on these buttons \
will increase or decrease the frequency by 1 Hz. If you double click or \
Shift click on the arrows, the frequency will change by 8 Hz. \n\
\n\
AFC \n\
This button will enable and disable the programs AFC function. When \
turned on, the AFC will capture a signal that is off frequency by as much \
as 7 Hz. \n\
\n\
Tx Freq \n\
This text field holds the frequency of you transmit tone. It is much like \
the Rx Freq window above, except that it has no special foreground color. \
You will probably not use this window much because setting it is automated \
by the NET button described below. \n\
\n\
Tx Freq Arrows \n\
The Up and Down arrows adjust the Tx Freq just like the ones for the \
Rx Freq described above. \n\
\n\
NET \n\
The NET button automates the setting of the Tx Freq. When the NET button \
is on, the current frequency in the Rx Freq will be transfered to the \
Tx Freq when you click on the Xmit button. This insure that you are \
transmitting on the same frequency that you were receiving. If it is off, \
and the Rx Freq and Tx Freq are different, you will be operating in a \
\"split mode\". \n\
\n\
T/R Controls \n\
The three buttons in the T/R Controls group allow you to key your \
transceiver. \n\
\n\
Recv \n\
This button puts you in receive mode. The audio going into your sound \
card will be decoded. \n\
\n\
Xmit \n\
This one puts you in transmit mode. The sound card will output the PSK \
codes for your keystrokes. The output audio can be used to key your \
transceiver via the VOX. \n\
\n\
The Xmit button also toggles the RTS line of your serial port card. The \
RTS signal can be used to key your rig with PTT. See any of the PSK \
web pages for the circuits needed for PTT operation. \n\
\n\
Tune \n\
The Tune button makes the sound card output a steady tone. This can be \
used for tuning your transmitter. \n\
\n\
NOTE: Do not exceed the power limit of your rig for continuous \
duty modes. \n\
\n\
Modes \n\
The Modes buttons are a column of five buttons along the lower right hand \
side of the interface. There are three mode buttons and two status \
indicators. The mode buttons are enabled when their indicator is red. \n\
\n\
DCD \n\
The top button in the stack is labeled DCD, and is an indicator only. \
Pushing this button has no effect. The indicator on the button turns \
red when a PSK signal is detected. \n\
\n\
QPSK \n\
When enabled, PSK is generated in the QPSK mode. When disabled, the code \
is generate in normal or BPSK mode. \n\
\n\
LSB \n\
This button should be enabled if you are transmitting in lower sideband. \n\
\n\
CW ID \n\
If this button is enabled, your call will be transmitted in CW when you \
switch from Xmit to Recv. \n\
\n\
IMD \n\
This window displays the IMD of the received signal. For the most \
accurate reading, the noise level must be low, and the signal should be \
in the idle state for at least 5 seconds. \n\
",

/***** TUNING SECTION *****/

"\n\
The main window decodes a PSK signal at the Rx Freq, which is the red line \
in the Spectrum display. There are two ways to get the PSK signal at the \
Rx Freq. You can bring the signal to the Rx Freq, or bring the program's \
Rx Freq to the signal. \n\
\n\
There are several ways you can tune a PSK signal. They range from manually, \
where you do most of the tuning, to scanning and the program does the all the \
work. In practice, you will find that you will use a combination of the \
following methods. So, it is best if you are know how to use all three \
methods. In all cases, the scope and spectrum displays will show you when \
the signal is properly tuned. \n\
\n\
Manually \n\
Tune your receiver until a PSK signal is in the Spectrum display. Try to \
center the signal on the red line, but don't try to get it perfect. Just \
use the receiver to do the course tuning. \n\
\n\
Then, use the Up and Down arrows in Rx Freq box to do the fine tuning. \
The Spectrum display will tell you which direction you need to tune. \
Remember, a double click on the arrows will change the frequency 8 Hz, and \
a single click will change it by 1 Hz. \n\
\n\
As you get close, several things will happen. The DCD indicator will turn \
red. Also, the lines in the Scope will be yellow and start to form a \
straight line. Once the line on the Scope is straight and you are within \
about 7 Hz. of the center frequency, the AFT will take over and finish the \
job for you. \n\
\n\
Click \n\
To use this method, you just tune until a PSK signal is shown anywhere in \
the Display. Then, point the mouse at the signal and push the left mouse \
button. The program will try to find and center on the signal, change the \
Rx Freq, and the AFC should do the rest. \n\
\n\
Notice that the program is now listening to a different frequency. Instead \
of tuning the receiver to the program's Rx Freq, like you did in the manual \
method, you \"tuned\" the program to a signal in the receivers bandpass. So, \
you can tune in signals without tuning the receiver. \n\
\n\
One way to use this is to tune your receiver to the low end of the PSK band \
segment. Now, every time you click near the right hand edge of the \
Spectrum, the Rx Freq changes to a higher frequency and you will see signal \
higher in the receivers bandpass. \n\
\n\
Band conditions and signal quality may cause it to line up incorrectly. For \
the best results, try to have the pointer within the white area of the \
signal. If it doesn't center correctly, you can click again or use the \
manual method. \n\
\n\
If you point and click at a spot where there is no signal, the program will \
simply set the Rx Freq to that frequency. If you have the Net button \
pressed, then this will now be your transmit frequency also. This is an \
easy way to select an open frequency to calling. \n\
\n\
Scan \n\
This method is the most automated. By hitting Ctrl-U or Ctrl-D, (see \
the ACCELERATOR KEYS section) the program will scan up or down the band \
and stop at the next PSK signal. While scanning, the Rx Text freq will be \
displayed with white numbers, which go back to black when the scan stops. \
\n\
If the scan reaches the \"edge of the world\" (0.0 Hz. or 3000 Hz.), the scan \
will stop before falling off the edge. As the scan approaches the edge, \
the spectrum display becomes solid gray. You can also stop a scan by \
hitting Ctrl-H, but there is an easier way described next. \
\n\
Besides using the Ctrl-H key to stop a scan, Ctrl-U and Ctrl-D will also \
stop a scanning operation. Here is a trick I use for scanning. Hold the \
Ctrl key down with your left hand, and hit the U or D key with your right. \
Keep your finger near the U or D key you just struck. If the scan stops \
and you want to restart it, just hit the same key with your right hand. \
Also, if you see the scan miss a signal, the same keystroke will stop the \
scan so you can tune back to it. Yes, sometimes a scan will miss a signal \
but catch it going back in the other direction. \n\
\n\
High noise levels, signal quality, signal strength, QSB, and crowded band \
conditions may cause the scan to stop off a signal. However, it still \
seems to do a pretty good job. \n\
",

/***** SECONDARY WINDOWS *****/

"\n\
There are several secondary windows in twpsk. One of these (Video) \
has controls that are \"set and forget\", so you pop up these only when \
needed. The other windows are Secondary Decoders that allow you to copy up \
to 4 QSOs at once. \n\
\n\
Secondary Decoder Windows \n\
You can display up to three Decoder windows. These windows are capable of \
receive only, and have some of the same controls as the main window. There \
are two ways to open a Decoder window. \n\
\n\
The first way works like click to tune. Assume that you are copying a \
signal in the main window and another signal appears in the Spectrum \
display. If you do a right mouse click on the second signal, a Secondary \
Decoder will pop up with its Rx Freq set for that signal. Notice that the \
Rx Freq on the main window is unchanged, and is still copying the original \
signal. \n\
\n\
The second way is used when you have a signal tuned in on the main window \
and want to put it into a secondary window. To do this from the main menu, \
click Controls and then Open Decoder. Note that the accelerator key for \
this button is Ctrl-O, so you can do this from the keyboard as well. \n\
\n\
Now that the signal is in the Secondary decoder, you can use the main window \
to tune and tune in another signal, hit Ctrl-O to put it into another window \
and so on, until you have the maximum of three Secondary Decoders. Just \
don't tune your rig, or you will detune all of the signals. \n\
\n\
Most of the controls on the Secondary Decoder are the same as the main \
window. One difference is a button labeled <-> Main. This button will \
swap its window's contents with the main window. If you see someone calling \
CQ in a Secondary Decoder click on <-> Main and you are ready to call. \n\
\n\
The very first time you use a secondary window, it will pop up in the upper \
left corner of the screen. Just drag it to where you want it. Every time \
you quit twpsk, it saves the current location of all the secondary windows. \
From now on, the secondary windows will pop up in the same location they \
were when you last quit twpsk. \n\
\n\
Video Window \n\
This window has two slider controls and a Close button. Both sliders are \
for the Spectrum/Waterfall display. The Display Speed sets the refresh \
rate on the display. \n\
\n\
Brightness is for brightness! \n\
",

/***** SENDING FILES *****/

"\n\
There are many times when you want to send the same text, like CQ's or \
brag files. There are also times when you would like to be able to insert \
something into that text, like a name, signal report, or contest number. All \
of this can be done by putting the text in a file and having twpsk send the \
file. Below are the steps need to setup a file. \n\
\n\
Create the text file \n\
First, you must create the file and its text. To create the file, cd to \
the directory called twpskDir. It is located under your home directory. \
Now use your favorite text editor to create the file. The file name will \
appear as a button label, so pick meaningful names. \n\
\n\
Second, you need to tell twpsk about the file. This is done by editing \
the resource file, Twpsk. By default, Twpsk was placed in the directory: \n\
\n\
/usr/X11R6/lib/X11/app-defaults \n\
\n\
You will have to be root to edit it. If you installed a copy of Twpsk when \
installed twpsk, then you could edit your copy. \n\
\n\
Near the top of Twpsk is a line with \"Twpsk.buttonNames\". Its value \
is a comma delimited list of the file names. Add your new file name to the \
list. Each name in the list will appear as a button in the File drop down \
menu and will have a Ctrl-1 thru Ctrl-9 next to the name. \n\
\n\
The Ctrl-1 thru Ctrl-9 are accelerator keys. (See the Accelerator Keys section \
for more info). The names on the buttons will be in the same order as they are \
in the \"Twpsk.buttonNames\" resource. Also, they will be assigned a Ctrl key \
number in the same sequence. I suggest putting the names in some logical \
order. So for example, Ctrl-1 sends a CQ, Ctrl-2 send your first \
transmission, Ctrl-3 sends the next... \n\
\n\
There is a limit of 9 file buttons. You can have as many files as you \
want in twpskDir, but only 9 can be set up at one time. Just edit the \
resource file for different situations. \n\
\n\
Finally, you will have to restart the program for these changes to take \
effect. Now click on the File button on the Main Menu, and you should see \
a button with your file name and its Ctrl- number. Click on your file name \
and the text should appear in the Transmit Text window.\n\
\n\
Variable Data \n\
This feature is for those times when you would like to be able to insert \
something into a text file, like a name, signal report, or contest number. \n\
\n\
First, you will need to create the file, and tell twpsk about the file. \
This was described above. As you create the text for the file, simply \
put ~WORD into the text where you want to insert something.  WORD can be \
any word, like ~NAME, ~RST, etc... \n\
\n\
While sending a file, if ~WORD is found, the program will pop up a dialog \
box with the label WORD and you can enter the text you want in a text \
field. When you are finished, just hit the Enter key. You can have as \
many ~ fields in the file as you want. Use a good WORD, because the dialog \
box displays WORD as an indication as to what should be entered. \n\
\n\
Sending \n\
The files can be sent by clicking on File in the Menu Bar, and then \
selecting the file from the drop down menu. However, it is easier to use \
the Ctrl Accelerator keys, since you don't need to reach for the mouse. \
See the Keyboard section for more information. \n\
",

/***** MACROS SECTION *****/

"\n\
With Macros you can define your own key functions that allow you to \
send short strings of fixed text. The macros are \"associated\" with the \
Transmit Text window. This means the Transmit Text window must have the \
focus. Since Macros are used to send text, and if I have programmed things \
right, you will not have to worry about this. However, if the macro's text \
doesn't appear in the Transmit Text window, click on the Transmit Text \
window to make sure it has the focus. The Transmit Text window has the focus \
when it has a black border. \n\
\n\
Macros are defined in the resource file, Twpsk.  That part of Twpsk is \
listed below. \n\
\n\
! Translations for \"Over\", HisCall and \n\
! user defined macros. \n\
! \n\
! Create your own macros using lines like these. \n\
! \n\
! Shift Alt <Key>m:     sendMacro(WA0EIR)\\n\\ \n\
! Shift Alt <Key>F1:    sendMacro(WA0EIR)\\n\\ \n\
! Shift Alt <Key>F2:    sendMacro(WA0EIR WA0EIR)\\n\\ \n\
! Shift Alt <Key>s:     sendMacro(SK)\\n\\ \n\
! \n\
! The last two lines should not be modified. \n\
! Enter your macros after the line - \n\
! Twpsk*txText.translations:   #override\\n\\ \n\
\n\
Twpsk*txText.translations:   #override\\n\\ \n\
  Shift Alt <Key>o:     sendOver()\\n\\ \n\
  Shift Alt <Key>h:     sendHisCall() \\n\
\n\
\n\
\n\
In the lines above, lines that begin with an ! are comments. \
Use the examples shown in the comments as a pattern for your macros. \
Change the letter following <Key> to the letter you want to use, and change \
the text within the ( )'s of sendMacro to the text you want to send. \n\
\n\
Insert your macros between the line -  \n\
\n\
  Twpsk*txText.translations:   #override\\n\\ \n\
\n\
and - \n\
\n\
  Shift Alt <Key>o:     sendOver()\\n\\ \n\
\n\
You can use other keys besides Shift Alt, but it is best if you don't because \
some of these are already being used by your window manager and twpsk itself. \
Remember, Ctrl-x is already defined to put you into transmit mode. And, on \
my window manager (fvwm), Alt-f is the same as pressing the File button on the \
main menu bar. \n\
\n\
So, Shift Alt works best because there are no conflicts. This gives you \
room for somewhere around 45 macros - more than I can remember. If you want, \
Shift Ctrl and Alt Ctrl might work too. That's over 135 macros! \n\
",

/***** RESOURCE SECTION *****/

"\n\
The resource file, Twpsk, is an important part of this program. It allows \
you to customize the program to meet your needs WITHOUT recompiling. After \
making any changes to the resource file, you must restart twpsk to have the \
changes take affect. \n\
\n\
A quick look at the file will tell you that a line beginning with an \
exclamation point (!) is a comment. Lines in a resource file can become \
quite complex, but here we will look at just the basic rules. \n\
\n\
A line in the file contains two columns. The left column is the name \
of a widget and one of its properties, like height or width. The left column \
is followed by a colon (:) and any number of spaces or tabs. The right column \
is the value to be assigned to the property. It is important that no spaces \
follow the value! For example, if the right hand value were tan followed by \
a space, you would get an error message like this: \n\
\n\
Warning: Color name \"tan \" is not defined \n\
\n\
The dumb computer is looking for a four letter word. Notice it says it can't \
find \"tan \" - that's t, a, n, and a space - not just \"tan\". \n\
\n\
If you want to create your own color scheme, change one of the colors to \
red, and restart the program. Now you can see the parts of the interface \
controlled by that property. Be sure to look at the Edit and Help windows \
to see if your change affected these windows. You can then change this \
property to any color or rgb value (#rrggbb) you want, and then repeat this \
process for the other color properties. \n\
\n\
The first 130 lines or so of Twpsk have several resources that you may want \
to adjust. There are comments in the file that describe the property, and \
what values are valid. \
",

/****** ACCELERATOR KEYS SECTION ******/

"\n\
In an application like this one, where most of the input is text typed on the \
keyboard, reaching for the mouse can be awkward and slow. Therefore, most \
of the button presses have been accelerator keys so they can be \"pressed\" \
with keystrokes instead. For example, using these accelerator keys let you \
go to transmit mode, send macros, text, files, and go back to receive mode \
without ever touching the mouse. \n\
\n\
Notice that the buttons on the interface have a Ctrl-character next to \
there names. This is a visual reminder to you that the button can be \
\"pressed\" by using the Control key sequence. For example, the Xmit button \
can be pressed by holding down the Ctrl button and pressing the X key. \n\
\n\
Two exceptions to this are the Spectrum and Waterfall buttons, since they \
have a bitmap rather than a label. The can be pressed with Ctrl-S and \
Ctrl-W. \n\
\n\
There are some menu buttons that do not have a corresponding button on the \
main window, however they still have accelerator keys. They are described \
below. \n\
\n\
Click on the File button on the menu bar. You should see the names of the \
text files that you can send. Notice that they can be sent by using their \
Ctrl key too. (Ctrl-1, Ctrl-2, etc) \n\
\n\
Now click on the Controls button on the menu bar. Most of these buttons \
are also on the interface. However, notice that the Secondary decoders, \
and Video dialogs can be called with control keys. \n\
\n\
Next, click on the Seek button in the main menu bar. You should now be \
looking at the buttons to start and stop a seek. Their accelerator keys are \
listed to the right of the button names. \n\
\n\
The Menu Bar can also be used via the keyboard. If your window manager is \
behaving right, pressing F10 will display a 3D border around the File button \
in the Menu Bar. You can then use the left and right arrows to select a \
button in the Menu Bar. Press the space bar to display the options and use \
the up and down arrows to select an option and press the space bar. \n\
\n\
There are also some shortcut keystrokes available. Notice that some of the \
buttons in the Menu Bar and drop down menus have an underlined character. \
These buttons can be pushed by typing the underlined character, however the \
button must be displayed before this will work. For example entering \
F10 H A will select the Menu Bar (F10), then the Help button (H), and finally \
the About button (A)."
};
