/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Logger;
import Ice.SocketException;
import Ice.TimeoutException;
import IceInternal.InetSocketAddress;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import IceUtil.Debug;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

class Acceptor {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private ServerSocketConnection _connection;
    private int _backlog;
    private InetSocketAddress _addr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object;
        if (this._traceLevels.network >= 1) {
            object = "stopping to accept tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        Acceptor acceptor = this;
        synchronized (acceptor) {
            object = this._connection;
            this._connection = null;
        }
        if (object != null) {
            try {
                object.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void listen() {
        if (this._traceLevels.network >= 1) {
            String string = "accepting tcp connections at " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, string);
        }
    }

    public Transceiver accept(int n) {
        SocketConnection socketConnection = null;
        try {
            if (n == -1) {
                n = 0;
            } else if (n == 0) {
                n = 1;
            }
            socketConnection = (SocketConnection)this._connection.acceptAndOpen();
        }
        catch (InterruptedIOException interruptedIOException) {
            TimeoutException timeoutException = new TimeoutException();
            timeoutException.initCause(interruptedIOException);
            throw timeoutException;
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        if (this._traceLevels.network >= 1) {
            String string = "accepted tcp connection " + Network.toString(socketConnection);
            this._logger.trace(this._traceLevels.networkCat, string);
        }
        return new Transceiver(this._instance, (Connection)socketConnection);
    }

    public void connectToSelf() {
        String string = System.getProperty("microedition.hostname");
        if (string == null || string.length() == 0 || string.equals("0.0.0.0")) {
            try {
                string = this._connection.getLocalAddress();
            }
            catch (IOException iOException) {
                string = "127.0.0.1";
            }
        }
        try {
            Connection connection = Connector.open((String)("socket://" + string + ':' + this._connection.getLocalPort()));
            connection.close();
        }
        catch (IOException iOException) {
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
    }

    public String toString() {
        return this._addr.getAddress() + ":" + this._addr.getPort();
    }

    int effectivePort() {
        return this._addr.getPort();
    }

    Acceptor(Instance instance, String string, int n) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.initializationData().logger;
        this._backlog = 0;
        if (this._backlog <= 0) {
            this._backlog = 5;
        }
        String string2 = "socket://";
        if (n > 0) {
            string2 = string2 + ":" + n;
        }
        try {
            if (this._traceLevels.network >= 2) {
                String string3 = "attempting to bind to tcp socket on port " + n;
                this._logger.trace(this._traceLevels.networkCat, string3);
            }
            this._connection = (ServerSocketConnection)Connector.open((String)string2);
            this._addr = new InetSocketAddress(this._connection.getLocalAddress(), this._connection.getLocalPort());
        }
        catch (IOException iOException) {
            if (this._connection != null) {
                try {
                    this._connection.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
                this._connection = null;
            }
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        catch (RuntimeException runtimeException) {
            if (this._connection != null) {
                try {
                    this._connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._connection = null;
            }
            throw runtimeException;
        }
    }

    protected synchronized void finalize() throws Throwable {
        Debug.FinalizerAssert(this._connection == null);
    }
}

